define(['angular', 'app', 'moment'], function (angular, app, moment) {
	'use strict';

	app.controller('TrackersNavController', function ($scope, $filter, $state, $stateParams, TrackersService, TrackersConstants, GraphService, focusService, formatter) {

		angular.forEach($state.current.data.paramSections, function(section) {
			if (!section.service) {
				section.service = TrackersService.instance(section.paramValue);

				var supportsLatest = section.service.supportsLatest || (section.service.config && section.service.config.object.supportsLatest);

				if (supportsLatest && !section.service.latest) {
					section.service.getLatest();
				}
			}
		});
	});
});